function range=ContourRange(H,dH,Lay)
% range=ContourRange(H,dH [,Lay])
% gets a range min:dH:Max for the data in struct H to contour
% H is obtained from readDat yielding H(i).values
% dH is range interval. The number of significant didgets is also obtained
% from dH
% TO 100529

if nargin<2, error('Insufficient arguments'); end

if isstruct(H)
    if nargin==2
        m=+Inf; M=-Inf; dH=abs(dH);
        for i=1:length(H)
            m=min([m;H(i).values(:)]);
            M=max([M;H(i).values(:)]);
        end
    else
        for i=1:length(H)
            m=min(m,min(min(min(H(i).values(:,:,Lay)))));
            M=max(M,max(max(max(H(i).values(:,:,Lay)))));
        end
    end
else
    if nargin==2
        m=min(H(:));
        M=max(H(:));
    else
        m=min(min(min(H(:,:,Lay))));
        M=max(max(max(H(:,:,Lay))));
    end
end

N=(M-m)/dH+2;

if m<0, n=fix(m/dH)-1; else n=fix(m/dH); end

range=dH*(n:n+N);

if length(range)>250
    
    error(['ContourRange, the number of requested contours must be < 200, check input\n',...
          'Lowest=%g step=%g Highest=%g, number of contours: %d\n'],m,dH,M,length(range));
end
